
#version 120

uniform float t;
uniform sampler2D wall;
uniform sampler2D clouds;
uniform sampler2D title;

void main()
{
	vec4 wallc = texture2D(wall, gl_TexCoord[0].st);
	vec4 cloudsc = texture2D(clouds, gl_TexCoord[1].st + vec2(0, 0.07 + t * 0.01));
	vec4 titlec = texture2D(title, gl_TexCoord[2].st - vec2(0.65, 4.45));
	
	vec4 a = 2 * wallc * cloudsc;
	gl_FragColor = a + (wallc - a) * wallc; // overlay
	gl_FragColor = mix(gl_FragColor, gl_FragColor * cloudsc, 0.1); // multiply 10%
	gl_FragColor = mix(wallc, gl_FragColor, cloudsc.w);
	
	vec4 cloudmask = texture2D(clouds, gl_TexCoord[1].st + vec2(0, 0.2));
	cloudmask = clamp(cloudmask * cloudmask + clamp((t - 2) * 0.3, -1, 1) - clamp((t - 6) * 0.3, 0, 2), vec4(0,0,0,0), vec4(1,1,1,1));
	//gl_FragColor = mix(gl_FragColor, cloudmask * cloudmask, titlec.w);
	vec4 color = 1 - (1 - gl_FragColor) / (titlec + 0.01);
	if (gl_TexCoord[2].s < 0.655 || gl_TexCoord[2].t < 4.455 || gl_TexCoord[2].s > 1.645 || gl_TexCoord[2].t > 5.445)
		cloudmask.x = 0.0;
	gl_FragColor = mix(gl_FragColor, color, cloudmask.x); // burn title
	
	gl_FragColor.w = 1; 
}

